/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.link;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlock;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class RedstoneLinkBlockEntity
extends SmartBlockEntity {
    private boolean receivedSignalChanged;
    private int receivedSignal;
    private int transmittedSignal;
    private ServerLinkBehaviour link;
    private boolean transmitter;
    public FactoryPanelSupportBehaviour panelSupport;

    public RedstoneLinkBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.REDSTONE_LINK, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.panelSupport = new FactoryPanelSupportBehaviour(this, () -> this.link != null && this.link.isListening(), () -> this.receivedSignal > 0, () -> AllBlocks.REDSTONE_LINK.updateTransmittedSignal(this.method_11010(), this.field_11863, this.field_11867));
        behaviours.add(this.panelSupport);
    }

    @Override
    public void addBehavioursDeferred(List<BlockEntityBehaviour<?>> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    protected void createLink() {
        this.link = this.transmitter ? ServerLinkBehaviour.transmitter(this, this::getSignal) : ServerLinkBehaviour.receiver(this, this::setSignal);
    }

    public int getSignal() {
        return this.transmittedSignal;
    }

    public void setSignal(int power) {
        if (this.receivedSignal != power) {
            this.receivedSignalChanged = true;
        }
        this.receivedSignal = power;
    }

    public void transmit(int strength) {
        this.transmittedSignal = strength;
        if (this.link != null) {
            this.link.notifySignalChange();
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71472("Transmitter", this.transmitter);
        view.method_71465("Receive", this.getReceivedSignal());
        view.method_71472("ReceivedChanged", this.receivedSignalChanged);
        view.method_71465("Transmit", this.transmittedSignal);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.transmitter = view.method_71433("Transmitter", false);
        super.read(view, clientPacket);
        this.receivedSignal = view.method_71424("Receive", 0);
        this.receivedSignalChanged = view.method_71433("ReceivedChanged", false);
        if (this.field_11863 == null || this.field_11863.method_8608() || !this.link.newPosition) {
            this.transmittedSignal = view.method_71424("Transmit", 0);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isTransmitterBlock() != this.transmitter) {
            this.transmitter = this.isTransmitterBlock();
            ServerLinkBehaviour prevlink = this.link;
            this.removeBehaviour(ServerLinkBehaviour.TYPE);
            this.createLink();
            this.link.copyItemsFrom(prevlink);
            this.attachBehaviourLate(this.link);
        }
        if (this.transmitter) {
            return;
        }
        if (this.field_11863.method_8608()) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!blockState.method_27852((class_2248)AllBlocks.REDSTONE_LINK)) {
            return;
        }
        if (this.getReceivedSignal() > 0 != (Boolean)blockState.method_11654((class_2769)RedstoneLinkBlock.POWERED)) {
            this.receivedSignalChanged = true;
            this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_28493((class_2769)RedstoneLinkBlock.POWERED));
        }
        if (this.receivedSignalChanged) {
            this.updateSelfAndAttached(blockState);
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.updateSelfAndAttached(this.method_11010());
    }

    public void updateSelfAndAttached(class_2680 blockState) {
        class_2350 attachedFace = ((class_2350)blockState.method_11654((class_2769)RedstoneLinkBlock.field_10927)).method_10153();
        class_2338 attachedPos = this.field_11867.method_10093(attachedFace);
        this.field_11863.method_8408(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
        this.field_11863.method_8408(attachedPos, this.field_11863.method_8320(attachedPos).method_26204());
        this.receivedSignalChanged = false;
        this.panelSupport.notifyPanels();
    }

    protected Boolean isTransmitterBlock() {
        return (Boolean)this.method_11010().method_11654((class_2769)RedstoneLinkBlock.RECEIVER) == false;
    }

    public int getReceivedSignal() {
        return this.receivedSignal;
    }
}

